<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="container py-5">
    
    <!-- Upcoming Workshops -->
    <?php if (!empty($upcoming_workshops)): ?>
        <section class="mb-5">
            <h2 class="fw-bold mb-4">
                <i class="fas fa-calendar-alt text-warning"></i> Upcoming Workshops
            </h2>
            <div class="row">
                <?php foreach ($upcoming_workshops as $workshop): ?>
                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="card h-100 shadow-sm border-0 workshop-card">
                            <?php if (!empty($workshop->featured_image)): ?>
                                <img src="<?php echo base_url('uploads/workshops/' . $workshop->featured_image); ?>" 
                                     class="card-img-top" 
                                     alt="<?php echo htmlspecialchars($workshop->title); ?>"
                                     style="height: 220px; object-fit: cover;">
                            <?php else: ?>
                                <div class="card-img-top bg-light d-flex align-items-center justify-content-center" 
                                     style="height: 220px;">
                                    <i class="fas fa-chalkboard-teacher fa-4x text-muted"></i>
                                </div>
                            <?php endif; ?>
                            
                            <div class="card-body">
                                <span class="badge bg-warning text-dark mb-2">Upcoming</span>
                                <?php if ($workshop->is_featured): ?>
                                    <span class="badge bg-primary mb-2">
                                        <i class="fas fa-star"></i> Featured
                                    </span>
                                <?php endif; ?>
                                
                                <h5 class="card-title fw-bold">
                                    <?php echo htmlspecialchars($workshop->title); ?>
                                </h5>
                                
                                <p class="card-text text-muted">
                                    <?php echo htmlspecialchars(character_limiter($workshop->description, 100)); ?>
                                </p>
                                
                                <div class="workshop-details">
                                    <?php if (!empty($workshop->duration)): ?>
                                        <p class="mb-2">
                                            <i class="far fa-clock text-primary"></i>
                                            <small><?php echo htmlspecialchars($workshop->duration); ?></small>
                                        </p>
                                    <?php endif; ?>
                                    
                                    <?php if (!empty($workshop->start_date)): ?>
                                        <p class="mb-2">
                                            <i class="far fa-calendar text-primary"></i>
                                            <small><?php echo date('M d, Y', strtotime($workshop->start_date)); ?></small>
                                        </p>
                                    <?php endif; ?>
                                    
                                    <?php if (!empty($workshop->location)): ?>
                                        <p class="mb-2">
                                            <i class="fas fa-map-marker-alt text-primary"></i>
                                            <small><?php echo htmlspecialchars($workshop->location); ?></small>
                                        </p>
                                    <?php endif; ?>
                                </div>
                                
                                <a href="<?php echo base_url('workshops/view/' . $workshop->slug); ?>" 
                                   class="btn btn-primary w-100 mt-3">
                                    View Details <i class="fas fa-arrow-right ms-2"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </section>
    <?php endif; ?>
    
    <!-- Ongoing Workshops -->
    <?php if (!empty($ongoing_workshops)): ?>
        <section class="mb-5">
            <h2 class="fw-bold mb-4">
                <i class="fas fa-play-circle text-success"></i> Ongoing Workshops
            </h2>
            <div class="row">
                <?php foreach ($ongoing_workshops as $workshop): ?>
                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="card h-100 shadow-sm border-0 workshop-card">
                            <?php if (!empty($workshop->featured_image)): ?>
                                <img src="<?php echo base_url('uploads/workshops/' . $workshop->featured_image); ?>" 
                                     class="card-img-top" 
                                     alt="<?php echo htmlspecialchars($workshop->title); ?>"
                                     style="height: 220px; object-fit: cover;">
                            <?php else: ?>
                                <div class="card-img-top bg-light d-flex align-items-center justify-content-center" 
                                     style="height: 220px;">
                                    <i class="fas fa-chalkboard-teacher fa-4x text-muted"></i>
                                </div>
                            <?php endif; ?>
                            
                            <div class="card-body">
                                <span class="badge bg-success mb-2">Ongoing</span>
                                
                                <h5 class="card-title fw-bold">
                                    <?php echo htmlspecialchars($workshop->title); ?>
                                </h5>
                                
                                <p class="card-text text-muted">
                                    <?php echo htmlspecialchars(character_limiter($workshop->description, 100)); ?>
                                </p>
                                
                                <div class="workshop-details">
                                    <?php if (!empty($workshop->duration)): ?>
                                        <p class="mb-2">
                                            <i class="far fa-clock text-primary"></i>
                                            <small><?php echo htmlspecialchars($workshop->duration); ?></small>
                                        </p>
                                    <?php endif; ?>
                                    
                                    <?php if (!empty($workshop->location)): ?>
                                        <p class="mb-2">
                                            <i class="fas fa-map-marker-alt text-primary"></i>
                                            <small><?php echo htmlspecialchars($workshop->location); ?></small>
                                        </p>
                                    <?php endif; ?>
                                </div>
                                
                                <a href="<?php echo base_url('workshops/view/' . $workshop->slug); ?>" 
                                   class="btn btn-outline-primary w-100 mt-3">
                                    View Details <i class="fas fa-arrow-right ms-2"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </section>
    <?php endif; ?>
    
    <!-- Completed Workshops -->
    <?php if (!empty($completed_workshops)): ?>
        <section class="mb-5">
            <h2 class="fw-bold mb-4">
                <i class="fas fa-check-circle text-info"></i> Completed Workshops
            </h2>
            <div class="row">
                <?php foreach ($completed_workshops as $workshop): ?>
                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="card h-100 shadow-sm border-0 workshop-card">
                            <?php if (!empty($workshop->featured_image)): ?>
                                <img src="<?php echo base_url('uploads/workshops/' . $workshop->featured_image); ?>" 
                                     class="card-img-top" 
                                     alt="<?php echo htmlspecialchars($workshop->title); ?>"
                                     style="height: 220px; object-fit: cover; opacity: 0.8;">
                            <?php else: ?>
                                <div class="card-img-top bg-light d-flex align-items-center justify-content-center" 
                                     style="height: 220px;">
                                    <i class="fas fa-chalkboard-teacher fa-4x text-muted"></i>
                                </div>
                            <?php endif; ?>
                            
                            <div class="card-body">
                                <span class="badge bg-info mb-2">Completed</span>
                                
                                <h5 class="card-title fw-bold">
                                    <?php echo htmlspecialchars($workshop->title); ?>
                                </h5>
                                
                                <p class="card-text text-muted">
                                    <?php echo htmlspecialchars(character_limiter($workshop->description, 100)); ?>
                                </p>
                                
                                <div class="workshop-details">
                                    <?php if (!empty($workshop->duration)): ?>
                                        <p class="mb-2">
                                            <i class="far fa-clock text-primary"></i>
                                            <small><?php echo htmlspecialchars($workshop->duration); ?></small>
                                        </p>
                                    <?php endif; ?>
                                    
                                    <?php if (!empty($workshop->location)): ?>
                                        <p class="mb-2">
                                            <i class="fas fa-map-marker-alt text-primary"></i>
                                            <small><?php echo htmlspecialchars($workshop->location); ?></small>
                                        </p>
                                    <?php endif; ?>
                                </div>
                                
                                <a href="<?php echo base_url('workshops/view/' . $workshop->slug); ?>" 
                                   class="btn btn-outline-secondary w-100 mt-3">
                                    View Details <i class="fas fa-arrow-right ms-2"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </section>
    <?php endif; ?>
    
    <!-- Empty State -->
    <?php if (empty($upcoming_workshops) && empty($ongoing_workshops) && empty($completed_workshops)): ?>
        <div class="text-center py-5">
            <i class="fas fa-chalkboard-teacher fa-4x text-muted mb-3"></i>
            <h4 class="text-muted">No Workshops Available</h4>
            <p class="text-muted">Check back soon for upcoming workshop programmes.</p>
            <a href="<?php echo base_url(); ?>" class="btn btn-primary mt-3">
                <i class="fas fa-home"></i> Back to Home
            </a>
        </div>
    <?php endif; ?>
</div>

<style>
.workshop-card {
    transition: transform 0.3s, box-shadow 0.3s;
}

.workshop-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.15) !important;
}

.workshop-details {
    border-top: 1px solid #e9ecef;
    padding-top: 1rem;
    margin-top: 1rem;
}
</style>